// https://github.com/fnc12/embeddedRest

// ConsoleApplication9.cpp : Defines the entry point for the console application.
//

#include "stdafx.h"

#include "UrlRequest.hpp"

int main()
{
#ifdef _WIN32
   WSADATA wsaData;
   if (WSAStartup(MAKEWORD(2, 2), &wsaData) != 0) {
      return -1;
   }
#endif

   UrlRequest request;
   request.host("10.144.18.20");
   request.uri("/nislsc/call");
   JsonValueAdapter::Object_t params = {
      { "devices", std::vector<std::string>{"SLSC-12001-030FD4DE-Mod3","SLSC-12001-030FD4DE-Mod7"} },
      { "access", "ReadWrite" },
      { "force_reserve", true }
   };
   request.bodyJson(
   {
      { "id", "1" },
      { "jsonrpc", "2.0" },
      { "method", "initializeSession" },
      { "params", params }
   });

   request.method("POST");

   Response response = std::move(request.perform());
   if (response.statusCode() == 200) {
      rapidjson::Document jsonResp;
      rapidjson::ParseResult parseResult = jsonResp.Parse(response.body().c_str());

      if (jsonResp.HasMember("error")) {
         if (jsonResp["error"].HasMember("data")) {
            cout << jsonResp["error"]["data"]["nislsc_message"].GetString() << endl;
         }
         else {
            cout << jsonResp["error"]["message"].GetString() << endl;
         }

      }
      else {
         cout << "session id = " << jsonResp["result"]["session_id"].GetString() << endl;
      }
   }
   else {
      cout << "status code = " << response.statusCode() << endl;
   }

    return 0;
}

